from scripts.config.applications_config import full_path_xlsx
from scripts.core.handlers.generate_excel_file import generate_excel
from scripts.core.handlers.mongo_db_operations import MongoDbStart
from scripts.core.handlers.uploaded_file_ import extract_uploaded_data
from scripts.logging.loggers import logger


def read_data_from_api(file_data):
    try:
        decoded_data = extract_uploaded_data(file_data)
        db_class = MongoDbStart()
        db_created = db_class.mongo_create()
        db_class.mongo_insert(db_created, decoded_data)
        print("\nBusiness Name with most Violations")
        db_class.mongo_violation(db_created)
        print("\nBusiness Name with No Violations")
        db_class.mongo_no_violation(db_created)
        print("\nGenerating Excel file")
        cursor_data = db_class.mongo_view_results(db_created)
        generate_excel(full_path_xlsx, cursor_data)
    except Exception as e:
        logger.error("Exception occurred while submitting: ", e)
