# class for mongo operations
from scripts.config.applications_config import projection


class MongoDb:
    # find business name with most violations
    @staticmethod
    def violations_db(db):
        cursor_data = db.aggregate([
            {
                '$group': {
                    '_id': '$business_name',
                    'violations': {
                        '$sum': {
                            '$cond': [
                                {
                                    '$eq': [
                                        '$result', 'Violation Issued'
                                    ]
                                }, 1, 0
                            ]
                        }
                    }
                }
            }, {
                '$sort': {
                    'violations': -1
                }
            }, {
                '$limit': 1
            }, {
                projection: {
                    'business_name': '$_id',
                    '_id': 0
                }
            }
        ])
        return cursor_data

    # business names with no violations
    @staticmethod
    def no_violations_db(db):
        cursor_data = db.aggregate([
            {
                '$group': {
                    '_id': '$business_name',
                    'violations': {
                        '$sum': {
                            '$cond': [
                                {
                                    '$eq': [
                                        '$result', 'Violation Issued'
                                    ]
                                }, 1, 0
                            ]
                        }
                    }
                }
            }, {
                '$match': {
                    'violations': {
                        '$eq': 0
                    }
                }
            }, {
                projection: {
                    'business_name': '$_id',
                    '_id': 0
                }
            }
        ])
        return cursor_data

    # business name and dates based on results
    @staticmethod
    def view_db_data(db):
        cursor_data = db.aggregate([
            {
                projection: {
                    '_id': 0,
                    'result': 1,
                    'business_name': 1,
                    'date': 1
                }
            }
        ])
        return cursor_data
