# generating the Excel file
import pandas as pd

from scripts.logging.loggers import logger


def generate_excel(path_xlsx, cursor_data):
    try:
        data_list = []
        if cursor_data.alive > 0:
            for business_names in cursor_data:
                data_list.append(business_names)
            data_frame = pd.DataFrame(data_list, columns=['result', 'business_name', 'date'])
            print(data_frame)
            data_frame.to_excel(path_xlsx, index=False)
        else:
            print("Error")
    except Exception as e:
        logger.error("Exception occurred while generating excel: ", e)
