# reading conf file
import configparser


config = configparser.RawConfigParser()
config.read("conf/applications.conf")


# path
base_path = config.get("path", 'base_path')
sub_path = config.get("path", "sub_path")
log_path = config.get("path", "log_path")

# uvicorn
uvicorn_port = config.get("uvicorn", "uvicorn_port")
uvicorn_app = config.get("uvicorn", "uvicorn_app")

# file name
file_name_xlsx = config.get("file", "file_name_xlsx")
full_path_xlsx = base_path + sub_path + file_name_xlsx

# db connection
client_connect = config.get("connection", "mongodb")

# mongo
projection = config.get("mongodb", "projection")
db_name = config.get("mongodb", "db_name")
collection_name = config.get("mongodb", "collection_name")

# log
formatter_time = config.get("log", "formatter_time")
formatter_level = config.get("log", "formatter_level")
