# using mongo aggregation operations
import uvicorn

from fastapi import FastAPI
from scripts.config.applications_config import uvicorn_port
from scripts.logging.loggers import logger
from scripts.services.app_services_run import business_violate

app = FastAPI()
app.include_router(business_violate)


# starting the application
if __name__ == "__main__":
    try:
        print("Mongo Aggregations task")
        uvicorn.run(app, port=int(uvicorn_port))
    except Exception as e:
        logger.error("Interruption occurred: ", e)

# pip install python-multipart
