from fastapi import APIRouter, Request, UploadFile, File
from fastapi.templating import Jinja2Templates
from fastapi.responses import HTMLResponse

from scripts.constants.api_routes_config import api_upload, api_submit, api_csv
from scripts.config import application_config
from scripts.core.handlers.extracting_sending import extract_send_data
from scripts.core.handlers.uploaded_file_ import extract_uploaded_data
from scripts.logging.loggers import logger

sender_tasks = APIRouter()
templates = Jinja2Templates(application_config.base_path + application_config.core_path +
                            application_config.handlers_path)


# html form access using api
@sender_tasks.get(api_upload, response_class=HTMLResponse)
def template_render(request: Request):
    try:
        return templates.TemplateResponse(application_config.html_template, {"request": request})
    except Exception as e:
        logger.error("Some exception occurred : ", e)


# handling the form submit using api
@sender_tasks.post(api_submit)
async def submit_file_data(file_data: UploadFile = File(...)):
    try:
        extract_uploaded_data(application_config.full_path_csv, file_data)
    except Exception as e:
        logger.error("Some exception occurred while extracting the file: ", e)
    else:
        return {"msg": "file uploading successful..."}


# reading csv and loading the data to json finally publishing it to mqtt
@sender_tasks.get(api_csv)
def dict_to_json():
    try:
        extract_send_data()
    except Exception as e:
        logger.error("Some exception occurred: ", e)
    else:
        print("Data published")
        return {"msg": "Data published"}
