import logging
import os
from logging.handlers import RotatingFileHandler

from scripts.config import application_config
from scripts.config.application_config import formatter_time, formatter_level


def get_logger():
    """
     Creates a rotating log
     """
    __logger__ = logging.getLogger('')
    __logger__.setLevel(logging.INFO)
    log_formatter = f'%({formatter_time})s - %({formatter_level})-6s - %(message)s'
    time_format = "%Y-%m-%d %H:%M:%S"
    file_path = application_config.full_path
    formatter = logging.Formatter(log_formatter, time_format)
    if not os.path.exists(file_path):
        os.makedirs(file_path)
    log_file = os.path.join(f"{file_path}{application_config.topic_name}.log")
    temp_handler = RotatingFileHandler(log_file, maxBytes=1)
    temp_handler.setFormatter(formatter)
    __logger__.addHandler(temp_handler)

    return __logger__


logger = get_logger()
