import uvicorn
from fastapi import FastAPI

from scripts.config.application_config import uvicorn_port
from scripts.logging.loggers import logger
from scripts.services.app_services_run import sender_tasks

app = FastAPI()
app.include_router(sender_tasks)

# starting the application
if __name__ == "__main__":
    try:
        print("Fast API task")
        uvicorn.run(app, port=int(uvicorn_port))
    except Exception as e:
        logger.error("Interruption occurred: ", e)
