import json

from paho.mqtt.client import Client

from scripts.config import application_config
from scripts.core.handlers.dict_to_json import extract_data
from scripts.core.handlers.remove_list_json import remove_list
from scripts.logging.loggers import logger


def extract_send_data():
    try:
        dict_data = extract_data(application_config.full_path_csv)

        list_removed = remove_list(dict_data)
        # dumps the list to json
        json_data = json.dumps(list_removed)

        # create the paho client
        client = Client()
        client.connect(application_config.mqtt_host, int(application_config.mqtt_port))

        # publish the topic
        client.publish(application_config.topic_name, json_data)
        client.disconnect()
    except Exception as e:
        logger.error("Some exception occurred while sending file: ", e)
