import configparser


config = configparser.RawConfigParser()
config.read("conf/applications.conf")


# path
base_path = config.get("path", 'base_path')
sub_path = config.get("path", "sub_path")
core_path = config.get("path", "core_path")
handlers_path = config.get("path", "handlers_path")

# file name
file_name_csv = config.get("file", "file_name_csv")
file_name_json = config.get("file", "file_name_json")
file_mode = config.get("file", "file_mode")
full_path = base_path + sub_path
full_path_csv = full_path + file_name_csv
full_path_json = full_path + file_name_json

# mqtt
topic_name = config.get("mqtt", "topic")
mqtt_host = config.get("mqtt", "mqtt_host")
mqtt_port = config.get("mqtt", "port")
request_no = config.get("mqtt", "requests")

# uvicorn
uvicorn_port = config.get("uvicorn", "uvicorn_port")

# log
formatter_time = config.get("log", "formatter_time")
formatter_level = config.get("log", "formatter_level")

# data frame
orientation = config.get("dataframes", "orientation")

# html template
html_template = config.get("html", "html_template")
