import configparser


config = configparser.RawConfigParser()
config.read("conf/applications.conf")


# path
base_path = config.get("path", 'base_path')
sub_path = config.get("path", "sub_path")
full_path = base_path + sub_path


# mqtt
topic_name = config.get("mqtt", "topic")
mqtt_host = config.get("mqtt", "mqtt_host")
port = config.get("mqtt", "port")
request_no = config.get("mqtt", "requests")


# uvicorn
uvicorn_host = config.get("uvicorn", "uvicorn_host")
uvicorn_port = config.get("uvicorn", "uvicorn_port")
uvicorn_app = config.get("uvicorn", "uvicorn_app")

# file name
file_name_csv = config.get("file", "file_name_csv")
file_name_json = config.get("file", "file_name_json")
full_path_csv = base_path + sub_path + file_name_csv
full_path_json = base_path + sub_path + file_name_json

# db name
db_name = config.get("db", "db_name")
db_table = config.get("db", "db_table")

# encode
utf_encode = config.get("encode", "encode")

# log
formatter_time = config.get("log", "formatter_time")
formatter_level = config.get("log", "formatter_level")
