import uvicorn
from fastapi import FastAPI

from scripts.config.application_config import uvicorn_host, uvicorn_port, uvicorn_app
from scripts.logging.loggers import logger
from scripts.services.receiver_app_services_run import mqtt_receive

app = FastAPI()
app.include_router(mqtt_receive)

# starting the application
if __name__ == "__main__":
    try:
        print("MQTT task receiver")
        uvicorn.run(app, host=uvicorn_host, port=int(uvicorn_port))
    except Exception as e:
        logger.error("Interruption occurred: ", e)
