import paho.mqtt.client as mqtt
from fastapi import APIRouter

from scripts.constants.api_routes_config import api_index
from scripts.config.application_config import mqtt_host, port, request_no
from scripts.core.handlers.mqtt_receive_data import mqtt_receiver_call
from scripts.logging.loggers import logger

# This is the Subscriber

mqtt_receive = APIRouter()


@mqtt_receive.get(api_index)
def receiver():
    try:
        mqtt_receiver_call(mqtt, mqtt_host, port, request_no)
    except Exception as e:
        logger.error("Exception occurred: ", e)
