import sqlite3

from scripts.config.application_config import db_name, db_table, full_path
from scripts.logging.loggers import logger
from scripts.utilis.db_queries import DbQueries


class SqliteOperations:
    def __init__(self):
        # connecting to the database
        self.conn = sqlite3.connect(full_path + db_name)

    def create_db(self):
        try:
            # creating the table
            self.conn.execute(DbQueries().create_table)
            self.conn.close()
        except Exception as e:
            logger.error("Exception occurred while creating table: ", e)

    def insert_db(self, frames):
        try:
            # inserting data to table
            frames.to_sql(db_table, self.conn, if_exists='replace')
            self.conn.commit()
        except Exception as e:
            logger.error("Exception occurred while inserting data: ", e)

    def fetch_data(self):
        try:
            # Create a cursor
            cursor = self.conn.cursor()

            # Execute a SELECT statement to fetch data from the "details" table
            cursor.execute(DbQueries().select)
            return cursor
        except Exception as e:
            logger.error("Exception occurred while fetching data: ", e)
