from scripts.core.handlers.connection_mqtt_receiver import connect_mqtt
from scripts.core.handlers.message_mqtt_receive import message_mqtt
from scripts.logging.loggers import logger


def mqtt_receiver_call(mqtt, mqtt_host, port, request_no):
    try:
        client = mqtt.Client()
        client.connect(mqtt_host, int(port), int(request_no))
        client.on_connect = connect_mqtt
        client.on_message = message_mqtt
        client.loop_forever()
    except Exception as e:
        logger.error("Exception occurred while calling the mqtt: ", e)
