import json
from scripts.config.application_config import utf_encode
from scripts.core.handlers.convert_to_dictionary import json_to_dictionary
from scripts.logging.loggers import logger


def message_mqtt(client_name, userdata, msg):
    try:
        print(client_name, " ", userdata)
        # decoding the msg to string
        payload_decoded = msg.payload.decode(utf_encode)
        json_data = json.loads(payload_decoded)
        # decoded msg to list
        json_to_dictionary(json_data)
    except Exception as e:
        logger.error("Exception occurred while decoding the message: ", e)
