import pandas as pd

from scripts.core.handlers.display_data import display_fetched_data
from scripts.core.handlers.operations_db import SqliteOperations
from scripts.logging.loggers import logger


def json_to_dictionary(json_data):
    try:
        data_list = list(json_data.values())
        # list to dataframe
        frames = pd.DataFrame(data_list, index=None)
        obj_db = SqliteOperations()
        # inserting the data to table
        obj_db.insert_db(frames)
        # fetching the data
        data_fetched = obj_db.fetch_data()
        display_fetched_data(data_fetched)
    except Exception as e:
        logger.error("Exception occurred while converting to data frame: ", e)
