# mongo operations
from scripts.logging.loggers import logger


class MongoDB:

    @staticmethod
    def insert_data_many(collections, csv_dict_data):
        try:
            collections.insert_many(csv_dict_data)
        except Exception as e:
            logger.error("Some exception occurred while running insertion of csv: ", e)

    @staticmethod
    def insert_data_one(collections, user_data):
        try:
            collections.insert_one(dict(user_data))
        except Exception as e:
            logger.error("Some exception occurred while running insertion: ", e)

    @staticmethod
    def find_data_all(collections):
        try:
            cursor = collections.find({}, {"_id": 0})
            return cursor
        except Exception as e:
            logger.error("Some exception occurred while fetching: ", e)

    @staticmethod
    def update_data(collections, d_id, user_data):
        try:
            collections.update_one({"id": d_id}, {"$set": dict(user_data)})
        except Exception as e:
            logger.error("Some exception occurred while updating: ", e)

    @staticmethod
    def delete_data(collections, d_id):
        try:
            collections.delete_one({"id": d_id})
        except Exception as e:
            logger.error("Some exception occurred while deleting: ", e)

