# api for convert, read, insert, update and delete
from fastapi import UploadFile, File, APIRouter

from scripts.config import applications_conf_read
from scripts.constants import api_path_config
from scripts.core.handlers.cursor_handle import cursor_to_dict
from scripts.core.handlers.uploaded_file_ import extract_uploaded_data
from scripts.engine.connect_mongo import connection_mongo_db
from scripts.databases.models.db_model_mongo import User, UpdateUser
from scripts.utils.mongo.mongo_utils import MongoDB
from scripts.logging.loggers import logger

mongo_api = APIRouter()

collection = connection_mongo_db()
db_obj = MongoDB()


# index page
@mongo_api.get(api_path_config.route_index)
def start_app():
    return "Starting the app"


@mongo_api.post(api_path_config.route_insert_csv)
def csv_file(file_data: UploadFile = File(...)):
    try:
        extract_uploaded_data(applications_conf_read.csv_path, file_data, db_obj, collection)
    except Exception as e:
        logger.error("Some exception occurred while running csv insertion: ", e)
    else:
        return {"msg": "Data added"}


@mongo_api.post(api_path_config.route_insert_one)
def insert_one(user_data: User):
    try:
        db_obj.insert_data_one(collection, user_data)
    except Exception as e:
        logger.error("Some exception occurred while running insertion: ", e)
    else:
        return {"msg": "Data inserted"}


@mongo_api.post(api_path_config.route_view_all)
def view_data_all():
    try:
        cursor = db_obj.find_data_all(collection)
        data_fetch = cursor_to_dict(cursor)
        return data_fetch
    except Exception as e:
        logger.error("Some exception occurred while running view all: ", e)


@mongo_api.put(api_path_config.route_update)
def update_data(d_id: int, user_data: UpdateUser):
    try:
        db_obj.update_data(collection, d_id, user_data)
    except Exception as e:
        logger.error("Some exception occurred while running update: ", e)
    else:
        return {"msg": "Data Updated"}


@mongo_api.delete(api_path_config.route_delete + "{d_id}")
def delete_data(d_id: int):
    try:
        db_obj.delete_data(collection, d_id)
    except Exception as e:
        logger.error("Some exception occurred while running delete: ", e)
    else:
        return {"msg": "Data deleted"}
