# file upload to csv
import os

from scripts.config import applications_conf_read
from scripts.config.applications_conf_read import file_mode
from scripts.core.handlers.convert_to_json import file_convert_json
from scripts.logging.loggers import logger


def extract_uploaded_data(full_path_csv, file_data, db_obj, collection):
    try:
        filename, file_extension = os.path.splitext(file_data.filename)
        if file_extension == ".csv":
            with open(full_path_csv, file_mode) as file_object:
                file_object.write(file_data.file.read())
            csv_dict_data = file_convert_json(applications_conf_read.csv_path)
            db_obj.insert_data_many(collection, csv_dict_data)
        else:
            logger.error("Invalid File format")
    except Exception as e:
        logger.error("Some exception occurred while extracting data: ", e)
