# reading from the applications.conf
import configparser


config = configparser.RawConfigParser()
config.read("conf/applications.conf")


# path
base_path = config.get("path", 'base_path')
sub_path = config.get("path", "sub_path")
full_path = base_path + sub_path

# file
file_csv = config.get("file", "csv_file")
csv_path = full_path + file_csv
file_mode = config.get("file", "file_mode")

# mongo server
uri = config.get("connection", "mongodb")

# log
formatter_time = config.get("log", "formatter_time")
formatter_level = config.get("log", "formatter_level")

# uvicorn
uvicorn_port = config.get("uvicorn", "uvicorn_port")
uvicorn_app = config.get("uvicorn", "uvicorn_app")

# mongodb conf
db_name = config.get("connection", "db_name")
collection = config.get("connection", "collection")
