import uvicorn
from fastapi import FastAPI

from scripts.config.applications_conf_read import uvicorn_port
from scripts.logging.loggers import logger
from scripts.services.app_service_run import mongo_api

app = FastAPI()
app.include_router(mongo_api)

# starting the application
if __name__ == "__main__":
    try:
        print("Fast API task")
        uvicorn.run(app, port=int(uvicorn_port))
    except Exception as e:
        logger.error("Interruption occurred: ", e)
