# project to access Json and pandas
from scripts.config.application_config import path_time, path_pivot, path_melt, path_merge
from scripts.constants.app_constants import exception_msg
from scripts.core.handlers.app_class_operations import JsonPandas


def access_op():
    try:
        json_pandas = JsonPandas()

        print("Reading the Json file....")
        file_get = json_pandas.read_excel()
        file_concat = json_pandas.concat_data(file_get)

        print("Changing the time format")
        time_changed = json_pandas.to_time_change(file_concat)
        json_pandas.create_json(path_time, time_changed)

        print("Pivoting the dataframe")
        dict_data_pivoted, pivot_change = json_pandas.pivot_data(file_concat)
        json_pandas.create_json(path_pivot, dict_data_pivoted)

        print("Melting the dataframe")
        melt_change = json_pandas.melt_data(file_concat)
        json_pandas.create_json(path_melt, melt_change)

        print("Merging the dataframe")
        merge_change = json_pandas.merge_data(file_concat)
        json_pandas.create_json(path_merge, merge_change)

    except Exception as e:
        print(f'{exception_msg} {e}')
    else:
        print("Access complete")
