# merging the dataframe
import pandas as pd


def merge_frame(file):
    file_copy = file

    # creating two dataframes for the merge
    file_frame1 = file_copy[['Timestamp', 'kW']]
    file_frame2 = file_copy[['Timestamp', 'kVA']]

    # creating the merged dataframe merged_file
    merged_file = pd.merge(file_frame1, file_frame2, on='Timestamp')
    print(merged_file)

    #  for storing the merged frame to dictionary
    dict_cols = []
    for i in range(0, len(merged_file.columns)):
        key_dict = "label" + str(i)
        val_dict = merged_file.columns[i]
        dict_cols.append({key_dict: val_dict})

    # storing the header and body to json
    head_cols = {"header": dict_cols}
    body_vals = {"body": merged_file.to_dict(orient="records")}
    dict_new = {**head_cols, **body_vals}

    return dict_new
