# Reading the conf file
import configparser

from scripts.constants.app_constants import exception_msg

# config object
try:
    config = configparser.RawConfigParser()
    config.read("conf/application.conf")

    # reading paths from conf file
    path_excel = config.get("file_path", "excel_path")
    path_time = config.get("file_path", "json_time")
    path_pivot = config.get("file_path", "json_pivot")
    path_melt = config.get("file_path", "json_melt")
    path_merge = config.get("file_path", "json_merge")

    # reading date format from conf file
    date_format = config.get("Date_format", "date_format")
except Exception as e:
    print(f'{exception_msg} {e}')
