# class for accessing services
from scripts.constants.app_constants import exception_msg
from scripts.core.handlers.change_time_data import time_change
from scripts.core.handlers.csv_read_file import read_from_path
from scripts.core.handlers.data_concat import data_concat_excel
from scripts.core.handlers.json_output_fn import print_json
from scripts.core.handlers.melted_data_frames import melt_frame
from scripts.core.handlers.merge_data_frames import merge_frame
from scripts.core.handlers.pivoted_data_frames import pivot_frame


class JsonPandas:
    # read the excel file
    @staticmethod
    def read_excel():
        try:
            file_read = read_from_path()
        except Exception as e:
            print(f'{exception_msg} {e}')
        else:
            return file_read

    # creating the json
    @staticmethod
    def create_json(path, file):
        try:
            print_json(path, file)
        except Exception as e:
            print(f'{exception_msg} {e}')
        else:
            print("Json file created\n")

    # concatenating the data
    @staticmethod
    def concat_data(file):
        try:
            concatenated = data_concat_excel(file)
        except Exception as e:
            print(f'{exception_msg} {e}')
        else:
            return concatenated

    @staticmethod
    def to_time_change(file):
        try:
            time_changed = time_change(file)
        except Exception as e:
            print(f'{exception_msg} {e}')
        else:
            return time_changed

    # using the pivot function
    @staticmethod
    def pivot_data(file):
        try:
            dict_data_pivoted, data_pivoted = pivot_frame(file)
        except Exception as e:
            print(f'{exception_msg}{e}')
        else:
            return dict_data_pivoted, data_pivoted

    # using the melt function
    @staticmethod
    def melt_data(file):
        try:
            data_melted = melt_frame(file)
        except Exception as e:
            print(f'{exception_msg} {e}')
        else:
            return data_melted

    # using merge function
    @staticmethod
    def merge_data(file):
        try:
            data_merge = merge_frame(file)
        except Exception as e:
            print(f'{exception_msg} {e}')
        else:
            return data_merge
