# access class functions
from scripts.core.handlers.mongo_db_operations import MongoDbStart
from scripts.core.handlers.postgres_db_operations import PostgresStart


# mongo access
def mongo_db_access_op():
    db_class = MongoDbStart()
    db_created = db_class.mongo_create()
    while True:
        try:
            user_query = input("Enter insert/ update/ delete/ view/ quit : ")
            if user_query == 'insert':
                db_class.mongo_insert(db_created)
            elif user_query == 'update':
                db_class.mongo_update(db_created)
            elif user_query == 'delete':
                db_class.mongo_delete(db_created)
            elif user_query == 'view':
                db_class.mongo_view(db_created)
            elif user_query == 'view-all':
                db_class.mongo_view_all(db_created)
            else:
                print("Exiting....")
                break
        except Exception as e:
            print("Exception occurred: ", e)
        else:
            choice = input("Do you want to continue (yes/no): ")
            if choice == 'yes':
                continue
            else:
                print("Thank you....")
                break


# postgres access
def postgres_db_access_op():
    db_postgres_class = PostgresStart()
    create_result = db_postgres_class.post_create()
    if not create_result:
        print("Cannot create table")
        return False
    while True:
        try:
            user_query = input("Enter insert/ update/ delete/ view/ quit : ")
            if user_query == 'insert':
                db_postgres_class.post_insert()
            elif user_query == 'update':
                db_postgres_class.post_update()
            elif user_query == 'delete':
                db_postgres_class.post_delete()
            elif user_query == 'view':
                db_postgres_class.post_view()
            else:
                db_postgres_class.post_quit()
                print("Exiting....")
                break
        except Exception as e:
            print("Exception occurred: ", e)
        else:
            choice = input("Do you want to continue (yes/no): ")
            if choice == 'yes':
                continue
            else:
                print("Thank you....")
                return True

