# class for postgresSql
from scripts.constants.proj_constants import ConstantsValues
from scripts.core.database.postgres.postgres_connect import cur, postgres_client
from scripts.core.handlers.postgres_data_del import delete_db_post, db_delete_post
from scripts.core.handlers.postgres_data_insert import read_inputs_post, insert_data_post
from scripts.core.handlers.postgres_data_update import input_update_post, db_update_post
from scripts.core.handlers.postgres_data_view import view_fields_post, input_view_post
from scripts.core.handlers.postgres_table_create import create_table


class PostgresStart:
    @staticmethod
    def post_create():
        try:
            client_cursor = cur
            check_result = create_table(client_cursor)
            if not check_result:
                return False
            else:
                return check_result
        except Exception as e:
            print(f'{ConstantsValues().exception_msg}{e}')

    @staticmethod
    def post_insert():
        try:
            num_prod = int(input("Enter the number of products: "))
            while num_prod > 0:
                p_name, p_category, retail_price, discount_price, description, over_rating = read_inputs_post()
                insert_check = insert_data_post(cur, p_name,
                                                p_category, retail_price, discount_price, description, over_rating)
                if insert_check:
                    print("Data inserted....")
                    num_prod -= 1
                else:
                    print("Something went wrong data cannot be inserted....")
        except Exception as e:
            print("Insertion failed", e)

    @staticmethod
    def post_update():
        try:
            condition_values, update_values = input_update_post()
            update_check = db_update_post(cur, condition_values, update_values)
            if update_check is None:
                print("Data updated")
            else:
                print("Data not updated")
        except Exception as e:
            print(f'{ConstantsValues().exception_msg},{e}')

    @staticmethod
    def post_delete():
        try:
            condition_values = delete_db_post()
            del_check = db_delete_post(cur, condition_values)
            if del_check is None:
                print("Data deleted")
            else:
                print("Data not deleted")
        except Exception as e:
            print(f'{ConstantsValues().exception_msg}{e}')

    @staticmethod
    def post_view():
        try:
            condition_values = input_view_post()
            view_fields_post(cur, condition_values)

        except Exception as e:
            print(f'{ConstantsValues().exception_msg}{e}')

    @staticmethod
    def post_quit():
        # Close the cursor and connection
        cur.close()
        postgres_client.close()
