# view db data
# display conditions
import pandas as pd

from scripts.constants.proj_constants import ConstantsValues
from scripts.core.database.postgres.queries.post_queries import QueriesPost
from scripts.core.handlers.get_post_columns import post_columns


# user input for fetch
def input_view_post():
    columns_ = post_columns()
    counter = 0
    condition_values = {}
    print("Conditions")
    while counter < len(columns_):
        field_value = input(f"Enter the {columns_[counter]} data: ")
        if field_value != '':
            condition_values.update({columns_[counter]: field_value})
        counter += 1

    return condition_values


# view the data
def view_fields_post(cur, condition_values):
    conditions = [f"{field} = '{value}'" for field, value in condition_values.items()]
    conditions = " and ".join(conditions)
    if conditions:
        print(conditions)
        cur.execute(QueriesPost().fetch_conditions(conditions))
        cursor_data = cur.fetchall()
        if cursor_data:
            print("Data collected....")
            view_data = pd.DataFrame((view_data_record for view_data_record in cursor_data),
                                     columns=ConstantsValues().columns_names)
            print(view_data)
        else:
            print("Data fetching failed")
    else:
        cur.execute(QueriesPost().fetch_all())
        cursor_data = cur.fetchall()
        if cursor_data:
            print("Data collected....")
            view_data = pd.DataFrame((view_data_record for view_data_record in cursor_data),
                                     columns=ConstantsValues().columns_names)
            print(view_data)
        else:
            print("Data fetching failed")
