# class for mongodb operations
from scripts.config.postgres_connect_config import dbname, products
from scripts.constants.proj_constants import ConstantsValues
from scripts.core.database.mongo.mongodb_connect import client
from scripts.core.handlers.data_insert import insert_data_db, read_inputs
from scripts.core.handlers.delete_db_data import delete_db_input, db_delete
from scripts.core.handlers.update_mongo_db import db_update, input_update_db
from scripts.core.handlers.view_data_db import view_fields, view_cond


class MongoDbStart:
    # create mongo table
    @staticmethod
    def mongo_create():
        try:
            client_con = client
        except Exception as e:
            print("Connection failed: ", e)
        else:
            db = client_con[dbname]
            store_manager = db[products]
            return store_manager

    # mongo data insert
    @staticmethod
    # getting input and insert into db
    def mongo_insert(db):
        try:
            num_prod = int(input("Enter the number of products: "))
            while num_prod > 0:
                p_id, p_name, p_category, retail_price, discount_price, description, over_rating = read_inputs()
                insert_check = insert_data_db(db, p_id, p_name,
                                              p_category, retail_price, discount_price, description, over_rating)
                if insert_check.acknowledged:
                    print("Data inserted....")
                    num_prod -= 1
                else:
                    print("Something went wrong data cannot be inserted....")
        except Exception as e:
            print("Insertion failed", e)

    # mongo update table
    @staticmethod
    def mongo_update(db):
        try:
            condition_values, update_values = input_update_db()
            update_check = db_update(db, condition_values, update_values)
            if update_check.matched_count > 0:
                print("Data updated")
            else:
                print("Data not updated")
        except Exception as e:
            print(f'{ConstantsValues().exception_msg}{e}')

    # mongo delete data
    @staticmethod
    def mongo_delete(db):
        try:
            condition_values = delete_db_input()
            del_check = db_delete(db, condition_values)
            if del_check.deleted_count > 0:
                print("Data deleted")
            else:
                print("Data not deleted")
        except Exception as e:
            print(f'{ConstantsValues().exception_msg}{e}')

    # mongo view data
    @staticmethod
    def mongo_view(db):
        try:
            field_filter = view_cond()
            view_fields(db, field_filter)

        except Exception as e:
            print(f'{ConstantsValues().exception_msg}{e}')
