from scripts.config.postgres_connect_config import products


class QueriesPost:
    @staticmethod
    def databases():
        db = "SELECT datname FROM pg_database WHERE datistemplate = false;"
        return db

    @staticmethod
    def create_table():
        table = f"CREATE TABLE if not exists {products} " \
                f"(product_id SERIAL PRIMARY KEY, product_name VARCHAR(255)," \
                f"product_category VARCHAR(255)," \
                f"retail_price INT," \
                f"discounted_price INT," \
                f"description VARCHAR(255)," \
                f"overall_rating INT)"
        return table

    @staticmethod
    def insert_data():
        insert_data = f"INSERT INTO {products} (product_name, product_category, retail_price, discounted_price," \
                           f"description, overall_rating) VALUES (%s, %s, %s, %s, %s, %s)"
        return insert_data

    @staticmethod
    def update_data(updates, conditions):
        view_data = f"UPDATE {products} SET {updates} WHERE {conditions}"
        return view_data

    @staticmethod
    def fetch_conditions(conditions):
        fetch_data = f"SELECT * FROM {products} WHERE {conditions}"
        return fetch_data

    @staticmethod
    def fetch_all():
        fetch_data = f"SELECT * FROM {products} ORDER BY product_id ASC"
        return fetch_data

    @staticmethod
    def delete_data(del_data):
        del_val = f"DELETE FROM {products} WHERE {del_data}"
        return del_val
