# postgres db connection
import psycopg2 as py

from scripts.config.postgres_connect_config import host_name, port, dbname, user, password
from scripts.constants.proj_constants import ConstantsValues
from scripts.core.database.postgres.queries.post_queries import QueriesPost

try:
    postgres_client = py.connect(host=host_name, port=port, user=user, password=password)
    postgres_client.set_session(autocommit=True)

    # creating cursor for the postgres
    cur = postgres_client.cursor()

    cur.execute(QueriesPost().databases())

    # Fetch the result
    result = cur.fetchall()

    # check if database exist
    if (dbname,) in result:
        postgres_client = py.connect(host=host_name, port=port, dbname=dbname, user=user, password=password)
        postgres_client.set_session(autocommit=True)
        cur = postgres_client.cursor()
    else:
        # end current
        postgres_client.commit()
        cur.execute(f'CREATE DATABASE {dbname}')
except Exception as e:
    print(f'{ConstantsValues().exception_msg},{e}')
