class MongoDBQuery:
    @staticmethod
    def insert(db, p_id, p_name, p_category, retail_price, discount_price, description, over_rating):
        cur = db.insert_one({"product_id": p_id, "product_name": p_name, "product_category": p_category,
                             "retail_price": retail_price, "discount_price": discount_price,
                             "description": description, "overall_rating": over_rating})
        return cur

    @staticmethod
    def update(db, condition_values, update_data):
        update_d = db.update_many(condition_values, update_data)
        return update_d

    @staticmethod
    def view(db, field_filter):
        view_data = db.find(field_filter, {'_id': 0})
        return view_data

    @staticmethod
    def delete(db, condition_values):
        delete_data = db.delete_one(condition_values)
        return delete_data
