# formatting the body for better view
import pandas as pd

from scripts.core.handlers.frames_format import format_data_frames


def data_format(column_mean, max_col, min_col):
    # using generators to split the dictionary values
    mean_col = (col for col in column_mean.items())
    max_cols = (col for col in max_col.items())
    min_cols = (col for col in min_col.items())

    # creating dataframes form generators
    mean_frame = pd.DataFrame(mean_col, columns=['Column_Names', 'Mean'])
    max_frame = pd.DataFrame(max_cols, columns=['Column_Names', 't_Max'])
    min_frame = pd.DataFrame(min_cols, columns=['Column_Names', 't_Min'])

    # splitting list in to separate columns
    max_frame[['Timestamp', 'Max_Values']] = max_frame['t_Max'].apply(pd.Series)
    max_frame = max_frame.drop(columns=['t_Max'], axis=1)

    min_frame[['Timestamp', 'Min_Values']] = min_frame['t_Min'].apply(pd.Series)
    min_frame = min_frame.drop(columns=['t_Min'], axis=1)

    return format_data_frames(mean_frame, max_frame, min_frame)


