# reading excel file contents
import pandas as pd

from scripts.config.app_path_config import path_excel
from scripts.core.handlers.format_body_email import data_format


def email_content_excel():
    data_task = pd.read_excel(path_excel)
    column_mean = {}
    max_column = {}
    min_column = {}

    for col in data_task.columns:
        if col == 'Timestamp':
            continue
        else:
            # timestamp of max values
            timestamp_max = data_task['Timestamp'][data_task[col].idxmax()]
            # timestamp of min values
            timestamp_min = data_task['Timestamp'][data_task[col].idxmin()]
            # max values of each columns
            max_val = round(data_task[col][data_task[col].idxmax()], 2)
            # min values of each columns
            min_val = round(data_task[col][data_task[col].idxmin()], 2)
            # appending mean, max, min in to dictionaries
            column_mean.update({col: round(data_task[col].mean(), 2)})
            max_column.update({col: [timestamp_max, max_val]})
            min_column.update({col: [timestamp_min, min_val]})

    return data_format(column_mean, max_column, min_column)
