# reading excel file
import ssl
from email.message import EmailMessage

from scripts.config.app_path_config import path_excel, file_name
from scripts.core.handlers.excel_file_content import email_content_excel


def content_create(sender_name, receiver_email, subject):
    mail = EmailMessage()
    mail['From'] = sender_name
    mail['To'] = receiver_email
    mail['Subject'] = subject
    email_content_excel()
    body = email_content_excel()
    mail.set_content(body)
    context = ''
    try:
        with open(path_excel, "rb") as file:
            file_data = file.read()
            mail.add_attachment(file_data, maintype='application', subtype='xlsx', filename=file_name)
        context = ssl.create_default_context()
    except Exception as e:
        print(e)
    return mail, context
