# import pi from constant
from scripts.constants import values

# class for shape circle
class Circle:
    def __init__(self, circle_radius):
        self.radius = circle_radius


# area child class inheriting class Circle
class Area(Circle):
    def __init__(self, circle_radius):
        super().__init__(circle_radius)

    def display_area(self):
        try:
            return values.pi * self.radius * self.radius
        except Exception as e:
            print(f'Exception occurred: {e}')


# perimeter child class inheriting class Circle
class Perimeter(Circle):
    def __init__(self, circle_radius):
        super().__init__(circle_radius)

    def display_perimeter(self):
        try:
            return 2 * values.pi * self.radius
        except Exception as e:
            print(f'Exception occurred: {e}')
