from scripts.core.handlers.receiver_handlers.connection_mqtt_receiver import connect_mqtt
from scripts.core.handlers.receiver_handlers.message_mqtt_receive import message_mqtt
from scripts.logging.loggers import logger
from scripts.utils.mqtt_connections import receiver_util_mqtt


def receive_mqtt():
    try:
        # connecting to broker
        client = receiver_util_mqtt()

        client.on_connect = connect_mqtt

        # listening to the topic
        client.on_message = message_mqtt

        client.loop_forever()
    except Exception as e:
        logger.error("Exception occurred while calling the mqtt: ", e)
