# reading from the applications.conf
import configparser

try:
    config = configparser.RawConfigParser()
    config.read("conf/applications.conf")

    # path
    base_path = config.get("path", 'base_path')
    sub_path = config.get("path", "sub_path")
    full_path = base_path + sub_path

    # log
    formatter_time = config.get("log", "formatter_time")
    formatter_level = config.get("log", "formatter_level")
    log_name = config.get("log", "log_name")

    # uvicorn
    uvicorn_port = config.get("uvicorn", "uvicorn_port")
    uvicorn_receiver_port = config.get("uvicorn", "receiver_port")

    # mqtt
    topic_name = config.get("mqtt", "topic")
    mqtt_host = config.get("mqtt", "mqtt_host")
    mqtt_port = config.get("mqtt", "port")
    request_no = config.get("mqtt", "requests")

    # encode
    utf_encode = config.get("encode", "encode")
except Exception as e:
    print(e)
