from datetime import date

from scripts.core.handlers.movie_observe import MovieObserveStatus
from scripts.logging.loggers import logger


class NewMarvelMovie(MovieObserveStatus):
    def __init__(self):
        try:
            # initializing the movie details
            MovieObserveStatus.__init__(self)
            self.movie_name = str
            self.movie_director = str
            self.movie_stars = str
            self.movie_release = date
        except Exception as e:
            logger.error("Exception occurred: ", e)

    def movie_create(self, movie):
        try:
            # storing the movie data
            self.movie_name = movie.movie_name
            self.movie_director = movie.movie_director
            self.movie_stars = movie.movie_stars
            self.movie_release = movie.movie_release
            self.notify()
        except Exception as e:
            logger.error("Exception occurred: ", e)

