import uvicorn
from fastapi import FastAPI

from scripts.config.applications_config import uvicorn_port
from scripts.logging.loggers import logger
from scripts.services import api_service_observe

app = FastAPI()
app.include_router(api_service_observe.marvel_movies)

# starting the application
if __name__ == "__main__":
    try:
        print("Observer task")
        uvicorn.run(app, port=int(uvicorn_port))
    except Exception as e:
        logger.error("Interruption occurred: ", e)
