from fastapi import APIRouter

from scripts.constants import api_path_config
from scripts.constants.api_response import response_data
from scripts.core.handlers.generate_new_movie import add_new_marvel
from scripts.logging.loggers import logger
from scripts.models.marvel_movie_details import Marvel

marvel_movies = APIRouter()


@marvel_movies.post(api_path_config.route_index)
def get_movie_details(movie: Marvel):
    try:
        add_new_marvel(movie)
    except Exception as e:
        logger.error("Interruption occurred: ", e)
    else:
        return response_data
