import logging

import jwt

from scripts.config import Secrets


class JWT:
    def __init__(self) -> None:
        self.max_login_age: int = Secrets.ACCESS_TOKEN_EXPIRE_MINUTES
        self.issuer: str = Secrets.issuer
        self.alg: str = Secrets.ALGORITHM
        self.key = Secrets.SECRET_KEY

    # encoding the payload
    def encode(self, payload) -> str:
        try:
            return jwt.encode(payload, self.key, algorithm=self.alg)
        except Exception as e:
            logging.exception(f"Exception while encoding JWT: {str(e)}")
            raise

    # decoding the payload
    def decode(self, token):
        try:
            return jwt.decode(token, self.key, algorithms=self.alg)
        except Exception as e:
            logging.exception(f"Exception while encoding JWT: {str(e)}")
            raise

    # validate the payload
    def validate(self, token):
        try:
            return jwt.decode(
                token,
                self.key,
                algorithms=self.alg,
                leeway=Secrets.leeway_in_minutes,
                options={"require": ["exp", "iss"]},
            )

        except Exception as e:
            logging.exception(f"Exception while validating JWT: {str(e)}")
