import pathlib
from typing import Literal

from pydantic import BaseSettings, Field


class _Services(BaseSettings):
    HOST: str = Field(default="127.0.0.1", env="service_host")
    PORT: int = Field(default=8000, env="service_port")
    PROJECT_NAME = Field(default="AssetManager", env="project_name")
    PROJECT_ID = Field(default="1256", env="project_id")
    ENCODING_TYPE = Field(default="utf-8", env="encoding_type")
    ENABLE_CORS: bool = True
    CORS_URLS: list[str] = ["*.ilens.io"]
    CORS_ALLOW_CREDENTIALS: bool = True
    CORS_ALLOW_METHODS: list[str] = ["GET", "POST", "DELETE", "PUT"]
    CORS_ALLOW_HEADERS: list[str] = ["*"]
    LOG_LEVEL: Literal["INFO", "DEBUG", "ERROR", "QTRACE"] = "INFO"
    ENABLE_FILE_LOGGING: bool = False
    KEY_ENCRYPTION = "kliLensKLiLensKL"
    SECRET_KEY = "09d25e094faa6ca2556c818166b7a9563b93f7099f6f0f4caa6cf63b88e8d3e7"
    ALGORITHM = "HS256"
    ACCESS_TOKEN_EXPIRE_MINUTES = 30


class _Databases(BaseSettings):
    MONGO_URI: str
    DB_NAME: str


class _BasePathConf(BaseSettings):
    BASE_PATH: str = "scripts/"


class _PathConf:
    BASE_PATH: pathlib.Path = pathlib.Path(_BasePathConf().BASE_PATH)
    LOG_PATH: pathlib.Path = BASE_PATH / "log/"


Services = _Services()
Databases = _Databases()
PathConf = _PathConf()

__all__ = [
    "Services",
    "Databases",
    "PathConf",
]
