from fastapi import APIRouter, HTTPException, status, Depends

from scripts.constants.api import ApiEndPoints
from scripts.core.handlers.login_handler import LoginHandlers
from scripts.core.handlers.user_management_handler import UserManagement
from scripts.errors import ErrorMessages
from scripts.logging.logger import logger
from scripts.schemas.project_schema import LoginRequest, RegistrationData
from scripts.utils.security.authorize_access import AuthorizeAccess
from scripts.utils.security.decorators import MetaInfoSchema, auth

# creating the login api
router = APIRouter(prefix=ApiEndPoints.version)
# initializing the handler
obj_login_handler = LoginHandlers()
obj_user_handler = UserManagement()


# login API
@router.post(ApiEndPoints.asset_manager_submit)
async def login_default(
        login_type: str,
        user_data: LoginRequest,
        request: MetaInfoSchema = Depends(auth)
):
    try:
        # mapper for login types
        login_mapper = {
            "normal": obj_login_handler.normal_login,
            "google": obj_login_handler.google_login,
            "microsoft": obj_login_handler.microsoft_login
        }

        # getting the functions based on the login types
        if login_type in login_mapper:
            return login_mapper[login_type](user_data, request)
        else:
            return HTTPException(
                status_code=status.HTTP_403_FORBIDDEN,
                detail="Invalid Request")

    except Exception as e:
        logger.exception(e)


# Create new users API
@router.post(ApiEndPoints.asset_manager_user_add)
async def user_register(
        user_data: RegistrationData,
        request: MetaInfoSchema = Depends(auth)
):
    try:
        response = AuthorizeAccess().admin_authorize(request)
        if not response:
            return HTTPException(
                status_code=status.HTTP_403_FORBIDDEN,
                detail=ErrorMessages.ERROR_UNAUTHORIZED_ACCESS)
        # mapper for login types
        register_mapper = {
            "normal": obj_user_handler.normal_register,
            "google": obj_user_handler.google_register,
            "microsoft": obj_user_handler.microsoft_register
        }

        # getting the functions based on the login types
        if user_data.login_type in register_mapper:
            return register_mapper[user_data.login_type](user_data)
        else:
            return HTTPException(
                status_code=status.HTTP_403_FORBIDDEN,
                detail="Invalid Request")

    except Exception as e:
        logger.exception(e)


# Update users API
@router.post(ApiEndPoints.asset_manager_user_update)
async def user_register(
        request: MetaInfoSchema = Depends(auth)
):
    try:
        response = AuthorizeAccess().admin_authorize(request)
        if not response:
            return HTTPException(
                status_code=status.HTTP_403_FORBIDDEN,
                detail=ErrorMessages.ERROR_UNAUTHORIZED_ACCESS)
    except Exception as e:
        logger.exception(e)


# Delete users API
@router.post(ApiEndPoints.asset_manager_user_delete)
async def user_register(
        request: MetaInfoSchema = Depends(auth)
):
    try:
        response = AuthorizeAccess().admin_authorize(request)
        if not response:
            return HTTPException(
                status_code=status.HTTP_403_FORBIDDEN,
                detail=ErrorMessages.ERROR_UNAUTHORIZED_ACCESS)
    except Exception as e:
        logger.exception(e)


# View users API
@router.post(ApiEndPoints.asset_manager_user_view)
async def user_register(
        request: MetaInfoSchema = Depends(auth)
):
    try:
        response = AuthorizeAccess().admin_authorize(request)
        if not response:
            return HTTPException(
                status_code=status.HTTP_403_FORBIDDEN,
                detail=ErrorMessages.ERROR_UNAUTHORIZED_ACCESS)
        return obj_user_handler.fetch_user_details()
    except Exception as e:
        logger.exception(e)
