import logging
import os
from logging.handlers import RotatingFileHandler

from scripts.config import Services, PathConf


def get_logger():
    """
     Creates a rotating log
     """
    __logger__ = logging.getLogger('')

    # setting the logger level
    __logger__.setLevel(Services.LOG_LEVEL)

    # creating the format for the log
    log_formatter = "%(asctime)s - %(levelname)-6s - [%(threadName)5s:%(funcName)5s(): %(lineno)s] - %(message)s"
    time_format = "%Y-%m-%d %H:%M:%S"

    # getting the path for the logger
    file_path = PathConf.LOG_PATH

    # setting the format
    formatter = logging.Formatter(log_formatter, time_format)

    # creating the folder if not exist
    if not os.path.exists(file_path):
        os.makedirs(file_path)
        
    # joining the path
    log_file = os.path.join(f"{file_path}/{Services.PROJECT_NAME}log.log")

    # creating rotating file handler with max byte as 1
    temp_handler = RotatingFileHandler(log_file, maxBytes=1)

    # setting the formatter
    temp_handler.setFormatter(formatter)

    # setting the handler
    __logger__.addHandler(temp_handler)

    return __logger__


logger = get_logger()
