from datetime import datetime, timedelta

from scripts.config import Secrets
from scripts.database.mongo.mongo_login import MongoUser
from scripts.database.redis.redis_conn import login_db
from scripts.utils.security.jwt_util import JWT

jwt = JWT()
mongo_user = MongoUser()


def create_token(
        user_id,
        ip,
        age=Secrets.ACCESS_TOKEN_EXPIRE_MINUTES,
        project_id=None,
):
    """
    This method is to create a cookie
    """
    # creating the payload
    payload = {"ip": ip, "user_id": user_id, "token": Secrets.SECRET_KEY, "age": age}
    if project_id:
        payload["project_id"] = project_id
    # getting the current time
    current_time = datetime.now()
    # generating the expiry time of the token
    exp = current_time + timedelta(minutes=age)
    # creating the dictionary with issuer and expiry time
    _extras = {"iss": Secrets.issuer, "exp": exp}
    _payload = payload | _extras
    # encoding the token
    new_token = jwt.encode(_payload)

    # Add session to redis
    login_db.set(user_id, new_token)
    login_db.expire(user_id, timedelta(minutes=age))

    # Add updated time to mongo db
    mongo_user.update_user({"email": user_id}, {"updated_at": current_time})

    return user_id
