from fastapi import APIRouter, HTTPException, status, Depends

from scripts.constants.api import ApiEndPoints
from scripts.core.handlers.login_handler import LoginHandlers
from scripts.logging.logger import logger
from scripts.schemas.login_schema import LoginRequest
from scripts.utils.security.decorators import MetaInfoSchema, auth

# creating the login api
router = APIRouter(prefix=ApiEndPoints.version)
# initializing the handler
obj_login_handler = LoginHandlers()


@router.post(ApiEndPoints.asset_manager_submit)
async def login_default(
        user_data: LoginRequest, request: MetaInfoSchema = Depends(auth)
):
    try:

        # mapper for login types
        login_mapper = {
            "normal": obj_login_handler.normal_login,
            "google": obj_login_handler.google_login,
            "microsoft": obj_login_handler.microsoft_login
        }

        # getting the functions based on the login types
        if user_data.login_type in login_mapper:
            return login_mapper[user_data.login_type](user_data, request)
        else:
            return HTTPException(
                status_code=status.HTTP_403_FORBIDDEN,
                detail="Invalid Request")

    except Exception as e:
        logger.exception(e)


# TODO user register
@router.post(ApiEndPoints.asset_manager_user_registration)
async def user_register():
    return {"message": "Available soon"}
