from scripts.core.handlers.normal_login import NormalLogin
from fastapi.responses import JSONResponse
from fastapi import status
from scripts.errors import ErrorMessages
from scripts.schemas.default_responses import DefaultFailureResponse, DefaultResponse


class LoginHandlers:
    def __init__(self):
        self.obj_login_handler = NormalLogin()

    def normal_login(self, login_data, request):

        # decrypting the password from the UI
        decrypted_password = self.obj_login_handler.password_decrypt(login_data.payload["password"])

        # validating the received inputs empty or not
        response = self.obj_login_handler.user_data_validation(
            login_data.payload["username"],
            login_data.project_id,
            decrypted_password)

        # Account is not registered
        if response is not None:
            return JSONResponse(content=DefaultFailureResponse(error=response).dict(),
                                status_code=status.HTTP_400_BAD_REQUEST)
        # checking for the account and password matching
        response, data = self.obj_login_handler.db_password_matching(login_data.payload,
                                                                     decrypted_password)
        # if the passwords doesn't match with the db data
        if response is not None:
            return JSONResponse(content=DefaultFailureResponse(error=data).dict(),
                                status_code=status.HTTP_401_UNAUTHORIZED)

        #  generating the access tokens
        response = self.obj_login_handler.generate_cookie_tokens(login_data.payload, request)
        # token generation unsuccessful
        if response is None:
            return JSONResponse(
                content=DefaultFailureResponse(message="Access Unsuccessful",
                                               error=ErrorMessages.ERROR_TOKEN_GENERATION).dict(),
                status_code=status.HTTP_403_FORBIDDEN)
        # sending successful response to UI
        return JSONResponse(
            content=DefaultResponse(message="Login Successful", payload=response).dict(),
            status_code=status.HTTP_200_OK)

    # v1
    def google_login(self, request):
        pass

    # v2
    def microsoft_login(self, request):
        pass
