from __future__ import annotations

from passlib.context import CryptContext

from scripts.database.mongo.mongo_login import MongoUser
from scripts.errors import ErrorMessages


class LoginHandlers:
    def __init__(self):
        self.pwd_context = CryptContext(schemes=["bcrypt"], deprecated="auto")
        self.db_user_data = None

    @staticmethod
    def user_data_validation(login_data) -> dict | None:
        if login_data.username == "" or login_data.username == "user@example.com":
            return {"message": ErrorMessages.ERROR_INVALID_USERNAME_PASSWORD, "data": login_data.username}
        if login_data.password == "" or login_data.password == "string":
            return {"message": ErrorMessages.ERROR_INVALID_USERNAME_PASSWORD, "data": login_data.password}
        return None

    def db_data_validation(self, login_data):
        self.db_user_data = MongoUser().fetch_user_details(login_data.username)
        if not self.db_user_data:
            return {"message": ErrorMessages.ERROR_USER_NOT_REGISTERED, "data": login_data.username}
        return None

    def db_password_matching(self, login_data):
        if response := self.db_data_validation(login_data):
            return response
        if not self.pwd_context.verify(login_data.password, self.db_user_data["password"]):
            return {"message": ErrorMessages.ERROR_PASSWORD_MISMATCH, "data": {login_data.username,
                                                                               login_data.password}}
        return None

